package com.agilex.healthcare.veteranappointment.datalayer.appointment;

import java.util.Set;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.veteranappointment.utils.SpringBasedIntegrationRepo;
import com.agilex.healthcare.veteranappointment.domain.VARDetailCode;

public class DetailCodeDataLayerRepoTest extends SpringBasedIntegrationRepo{

	@Resource
	DetailCodeDataLayerRepo dataLayer;

	private Set<VARDetailCode> detailCodes;
	
	@Before
	public void setUp() throws Exception {
		super.setUp();
		detailCodes = dataLayer.fetchDetailCodes();
	}
	
	@After
	public void tearDown() throws Exception {
		super.tearDown();
	}
	
	@Test
	public void validateNumberOFDetailCodes() {
		assertEquals(11, detailCodes.size());
	}
	
	@Test
	public void validateDetailCodes(){
		if(detailCodes == null || detailCodes.size() == 0)
			fail();
		
		for (VARDetailCode detailCode : detailCodes) {
			assertNotNull(detailCode.getCode());
			assertNotNull(detailCode.getProviderMessage());
			assertNotNull(detailCode.getVeteranMessage());
		}
	}
	
	@Test
	public void confirmGetDetailCodeByCode() throws Exception {
		VARDetailCode expected = new VARDetailCode();
		expected.setCode("DETCODE8");
		expected.setProviderMessage("Cancelled by Veteran - Pending");
		expected.setVeteranMessage("Your request to cancel this appointment has been sent."); 
		
		VARDetailCode fetchedDetailCode = dataLayer.fetchDetailCodeByCode(expected.getCode());
		assertNotNull(fetchedDetailCode);
		assertEquals(expected.getCode(), fetchedDetailCode.getCode());
		assertEquals(expected.getVeteranMessage(), fetchedDetailCode.getVeteranMessage());
		assertEquals(expected.getProviderMessage(), fetchedDetailCode.getProviderMessage());
	}
}
